/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;

public class GuiNbtBook
extends GuiNPCInterface
implements IGuiData,
ISubGuiListener {
    protected ItemStack blockStack;
    protected String errorMessage;
    protected String faultyText;
    protected String jsonCompound;
    protected IBlockState state;
    protected TileEntity tile;
    protected final int x;
    protected final int y;
    protected final int z;
    protected ItemStack stack;
    protected GuiCustomScroll scroll;
    public NBTTagCompound compound;
    public Entity entity;
    public int entityId;
    public NBTTagCompound originalCompound;

    public GuiNbtBook(int xPos, int yPos, int zPos) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.faultyText = null;
        this.errorMessage = null;
        this.x = xPos;
        this.y = yPos;
        this.z = zPos;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.compound == null) {
                    return;
                }
                if (this.jsonCompound == null || this.jsonCompound.isEmpty()) {
                    this.jsonCompound = this.compound.toString();
                }
                if (this.faultyText != null) {
                    this.setSubGui(new SubGuiNpcTextArea(this.jsonCompound, this.faultyText).enableHighlighting());
                    break;
                }
                this.setSubGui(new SubGuiNpcTextArea(this.jsonCompound).enableHighlighting());
                break;
            }
            case 1: {
                if (this.stack == null || this.stack.func_190926_b()) break;
                Client.sendData(EnumPacketServer.NbtBookCopyStack, this.stack.func_77955_b(new NBTTagCompound()));
                break;
            }
            case 2: {
                if (this.compound == null) {
                    return;
                }
                if (this.faultyText != null) {
                    this.setSubGui(new SubGuiNpcTextArea(this.compound.toString(), this.faultyText).enableHighlighting());
                    break;
                }
                this.setSubGui(new SubGuiNpcTextArea(this.compound.toString()).enableHighlighting());
                break;
            }
            case 66: {
                this.close();
                break;
            }
            case 67: {
                this.getLabel(0).setLabel("Saved");
                if (this.compound.equals((Object)this.originalCompound)) {
                    return;
                }
                if (this.stack != null) {
                    Client.sendData(EnumPacketServer.NbtBookSaveItem, this.compound);
                }
                if (this.tile == null) {
                    Client.sendData(EnumPacketServer.NbtBookSaveEntity, this.entityId, this.compound);
                } else {
                    Client.sendData(EnumPacketServer.NbtBookSaveBlock, this.x, this.y, this.z, this.compound);
                }
                this.originalCompound = this.compound.func_74737_b();
                button.setEnabled(false);
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface gui) {
        if (gui instanceof SubGuiNpcTextArea) {
            try {
                this.setCompound(JsonToNBT.func_180713_a((String)((SubGuiNpcTextArea)gui).text));
                this.faultyText = null;
                this.errorMessage = null;
            }
            catch (NBTException e) {
                this.errorMessage = e.getLocalizedMessage();
                this.faultyText = ((SubGuiNpcTextArea)gui).text;
            }
            this.func_73866_w_();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hasSubGui()) {
            return;
        }
        if (this.stack != null || this.state != null) {
            GlStateManager.func_179094_E();
            Gui.func_73734_a((int)(this.guiLeft + 3), (int)(this.guiTop + 3), (int)(this.guiLeft + 55), (int)(this.guiTop + 55), (int)-8355712);
            Gui.func_73734_a((int)(this.guiLeft + 4), (int)(this.guiTop + 4), (int)(this.guiLeft + 54), (int)(this.guiTop + 54), (int)-16777216);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 5), (float)(this.guiTop + 5), (float)0.0f);
            GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(this.stack != null ? this.stack : this.blockStack, 0, 0);
            this.field_146296_j.func_175030_a(this.field_146289_q, this.stack != null ? this.stack : this.blockStack, 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        if (this.entity != null) {
            GlStateManager.func_179094_E();
            this.drawNpc(this.entity, 30, 80, 1.0f, 0, 0, 1);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            int color = -8355712;
            if (EntityRegistry.getEntry(this.entity.getClass()) == null) {
                color = -49088;
            }
            Gui.func_73734_a((int)(this.guiLeft + 5), (int)(this.guiTop + 13), (int)(this.guiLeft + 55), (int)(this.guiTop + 99), (int)color);
            Gui.func_73734_a((int)(this.guiLeft + 6), (int)(this.guiTop + 14), (int)(this.guiLeft + 54), (int)(this.guiTop + 98), (int)-16777216);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_73866_w_() {
        boolean onlyClient;
        super.func_73866_w_();
        boolean bl = onlyClient = this.stack == null && this.state == null && this.entity == null;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(188, 120);
        }
        this.scroll.guiLeft = this.guiLeft + 60;
        this.scroll.guiTop = this.guiTop + 45;
        if (this.stack != null) {
            this.scroll.setSize(188, 118);
            this.scroll.guiTop -= 20;
            this.addLabel(new GuiNpcLabel(11, "id: \"" + this.stack.func_77973_b().getRegistryName() + "\"", this.guiLeft + 60, this.guiTop + 6));
            this.addButton(new GuiNpcButton(1, this.guiLeft + 38, this.guiTop + 144, 180, 20, "gui.copy"));
            this.setObjectToScroll(this.stack);
        } else if (this.state != null) {
            this.addLabel(new GuiNpcLabel(11, "x: " + this.x + ", y: " + this.y + ", z: " + this.z, this.guiLeft + 60, this.guiTop + 6));
            this.addLabel(new GuiNpcLabel(12, "id: " + Block.field_149771_c.func_177774_c((Object)this.state.func_177230_c()), this.guiLeft + 60, this.guiTop + 16));
            this.addLabel(new GuiNpcLabel(13, "meta: " + this.state.func_177230_c().func_176201_c(this.state), this.guiLeft + 60, this.guiTop + 26));
            this.setObjectToScroll(this.state);
        } else if (this.entity != null) {
            String name;
            this.scroll.setSize(188, 140);
            this.scroll.guiTop -= 20;
            if (EntityRegistry.getEntry(this.entity.getClass()) == null) {
                name = "Not registered name!";
                onlyClient = true;
            } else {
                name = "id: " + Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(this.entity.getClass())).getRegistryName());
            }
            this.addLabel(new GuiNpcLabel(12, name, this.guiLeft + 60, this.guiTop + 6));
            this.setObjectToScroll(this.entity);
        }
        this.addScroll(this.scroll);
        this.addLabel(new GuiNpcLabel(2, "nbt.edit", this.guiLeft + 4, this.guiTop + 172));
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + 128, this.guiTop + 166, 59, 20, "selectServer.edit");
        this.addButton(button);
        button.setEnabled(this.compound != null && !this.compound.func_150296_c().isEmpty());
        button = new GuiNpcButton(2, this.guiLeft + 189, this.guiTop + 166, 59, 20, "gui.fast");
        this.addButton(button);
        button.setEnabled(this.compound != null && !this.compound.func_150296_c().isEmpty());
        this.addLabel(new GuiNpcLabel(0, "", this.guiLeft + 4, this.guiTop + 167));
        this.addLabel(new GuiNpcLabel(1, "", this.guiLeft + 4, this.guiTop + 177));
        this.addButton(new GuiNpcButton(66, this.guiLeft + 128, this.guiTop + 190, 120, 20, "gui.close"));
        this.addButton(new GuiNpcButton(67, this.guiLeft + 4, this.guiTop + 190, 120, 20, "gui.save"));
        this.getButton(67).setEnabled(!onlyClient);
        if (!onlyClient) {
            if (this.errorMessage != null) {
                this.getButton(67).setEnabled(false);
                int i = this.errorMessage.indexOf(" at: ");
                if (i > 0) {
                    this.getLabel(0).setLabel(this.errorMessage.substring(0, i));
                    this.getLabel(1).setLabel(this.errorMessage.substring(i));
                } else {
                    this.getLabel(0).setLabel(this.errorMessage);
                }
            }
            if (this.getButton(67).isEnabled() && this.originalCompound != null) {
                this.getButton(67).setEnabled(!this.originalCompound.equals((Object)this.compound));
            }
        }
    }

    private void setObjectToScroll(Object obj) {
        int mdf;
        boolean isAccessible;
        this.addLabel(new GuiNpcLabel(15, "(?) Class \"" + obj.getClass().getSimpleName() + "\":", this.guiLeft + 60, this.guiTop + (this.state != null ? 36 : 16)));
        this.getLabel(15).setHoverText(obj.getClass().getName(), new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        TreeMap<String, Field> fs = new TreeMap<String, Field>();
        TreeMap<String, AccessibleObject> ms = new TreeMap<String, AccessibleObject>();
        TreeMap<String, AnnotatedElement> cs = new TreeMap<String, AnnotatedElement>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            fs.put(field.getName(), field);
        }
        for (Field field : obj.getClass().getFields()) {
            if (fs.containsKey(field.getName())) continue;
            fs.put(field.getName(), field);
        }
        for (AccessibleObject accessibleObject : obj.getClass().getDeclaredMethods()) {
            ms.put(((Method)accessibleObject).getName(), accessibleObject);
        }
        for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
            if (ms.containsKey(((Method)accessibleObject).getName())) continue;
            ms.put(((Method)accessibleObject).getName(), accessibleObject);
        }
        for (AnnotatedElement annotatedElement : obj.getClass().getDeclaredClasses()) {
            cs.put(((Class)annotatedElement).getName(), annotatedElement);
        }
        for (AnnotatedElement annotatedElement : obj.getClass().getClasses()) {
            if (cs.containsKey(((Class)annotatedElement).getName())) continue;
            cs.put(((Class)annotatedElement).getName(), annotatedElement);
        }
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String string : fs.keySet()) {
            try {
                Field f = (Field)fs.get(string);
                isAccessible = f.isAccessible();
                if (!isAccessible) {
                    f.setAccessible(true);
                }
                mdf = f.getModifiers();
                list.add("\u00a76F: \u00a7" + (Modifier.isPublic(mdf) ? "a" : "c") + string);
                hts.put(i, GuiNbtBook.getFieldTypes(obj, mdf, f));
                if (!isAccessible) {
                    f.setAccessible(false);
                }
            }
            catch (Exception e) {
                hts.put(i, Collections.singletonList(""));
                LogWriter.error(e);
            }
            ++i;
        }
        for (String string : ms.keySet()) {
            try {
                Method m = (Method)ms.get(string);
                isAccessible = m.isAccessible();
                if (!isAccessible) {
                    m.setAccessible(true);
                }
                mdf = m.getModifiers();
                list.add("\u00a73M: \u00a7" + (Modifier.isPublic(mdf) ? "a" : "c") + string);
                hts.put(i, GuiNbtBook.getMethodTypes(mdf, m));
                if (!isAccessible) {
                    m.setAccessible(false);
                }
            }
            catch (Exception e) {
                hts.put(i, Collections.singletonList(""));
                LogWriter.error(e);
            }
            ++i;
        }
        for (String string : cs.keySet()) {
            Class c = (Class)cs.get(string);
            int mdf2 = c.getModifiers();
            list.add("\u00a73M: \u00a7" + (Modifier.isPublic(mdf2) ? "a" : "c") + string);
            String mf = "\u00a79subclass: ";
            mf = Modifier.isPublic(mdf2) ? mf + "\u00a7apublic" : (Modifier.isProtected(mdf2) ? mf + "\u00a7cprotected" : mf + "\u00a74private");
            if (Modifier.isStatic(mdf2)) {
                mf = mf + "\u00a7e static";
            }
            if (Modifier.isFinal(mdf2)) {
                mf = mf + "\u00a7b final";
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(mf);
            l.add(c.getSimpleName());
            hts.put(i, l);
            ++i;
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setHoverTexts(hts);
    }

    private static List<String> getFieldTypes(Object obj, int mdf, Field f) throws IllegalAccessException {
        String mf = "\u00a76field: ";
        mf = Modifier.isPublic(mdf) ? mf + "\u00a7apublic" : (Modifier.isProtected(mdf) ? mf + "\u00a7cprotected" : mf + "\u00a74private");
        if (Modifier.isStatic(mdf)) {
            mf = mf + "\u00a7e static";
        }
        if (Modifier.isFinal(mdf)) {
            mf = mf + "\u00a7b final";
        }
        Object v = f.get(obj);
        ArrayList<String> l = new ArrayList<String>();
        l.add(mf);
        l.add("\u00a77value type: \u00a7r" + f.getType().getName());
        l.add("\u00a77value = \u00a7r" + (v != null ? v.toString() : "null"));
        return l;
    }

    private static List<String> getMethodTypes(int mdf, Method m) {
        String mf = "\u00a73method: ";
        mf = Modifier.isPublic(mdf) ? mf + "\u00a7apublic" : (Modifier.isProtected(mdf) ? mf + "\u00a7cprotected" : mf + "\u00a74private");
        if (Modifier.isStatic(mdf)) {
            mf = mf + "\u00a7e static";
        }
        if (Modifier.isFinal(mdf)) {
            mf = mf + "\u00a7b final";
        }
        ArrayList<String> hoverText = new ArrayList<String>();
        hoverText.add(mf);
        hoverText.add("\u00a77return type: \u00a7r" + m.getReturnType().getName());
        if (m.getParameters() != null && m.getParameters().length > 0) {
            hoverText.add("\u00a77parameters: (");
            Parameter[] prms = m.getParameters();
            for (int j = 0; j < prms.length; ++j) {
                String nm = "\u00a78" + prms[j].getType().getName();
                nm = nm.replace(prms[j].getType().getSimpleName(), "\u00a7e" + prms[j].getType().getSimpleName());
                nm = nm + "\u00a7r " + prms[j].getName() + (j < prms.length - 1 ? "," : "");
                hoverText.add(nm);
            }
            hoverText.add("\u00a77)");
        } else {
            hoverText.add("\u00a77parameters: \u00a7r()");
        }
        return hoverText;
    }

    @Override
    public void setGuiData(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Item") && nbt.func_74767_n("Item")) {
            this.stack = new ItemStack(nbt.func_74775_l("Data"));
        } else if (nbt.func_74764_b("EntityId")) {
            this.entityId = nbt.func_74762_e("EntityId");
            this.entity = this.player.field_70170_p.func_73045_a(this.entityId);
        } else {
            this.tile = this.player.field_70170_p.func_175625_s(new BlockPos(this.x, this.y, this.z));
            this.state = this.player.field_70170_p.func_180495_p(new BlockPos(this.x, this.y, this.z));
            this.blockStack = this.state.func_177230_c().func_185473_a(this.player.field_70170_p, new BlockPos(this.x, this.y, this.z), this.state);
        }
        this.originalCompound = nbt.func_74775_l("Data");
        this.setCompound(this.originalCompound.func_74737_b());
        this.func_73866_w_();
    }

    private void setCompound(NBTTagCompound nbt) {
        this.compound = nbt;
        this.jsonCompound = nbt.toString();
        CustomNPCsScheduler.runTack(() -> {
            this.jsonCompound = NBTJsonUtil.Convert(nbt);
        });
    }
}

